<?php
/**
 * @copyright	Copyright (c) 2018 PhCProduct. All rights reserved.
 * @license		http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

// no direct access
defined('_JEXEC') or die;

jimport('joomla.plugin.plugin');
if (!JComponentHelper::isEnabled('com_phocacart', true)) {
	$app = JFactory::getApplication();
	$app->enqueueMessage(JText::_('Phoca Cart Error'), JText::_('Phoca Cart is not installed on your system'), 'error');
	return;
}

JLoader::registerPrefix('Phocacart', JPATH_ADMINISTRATOR . '/components/com_phocacart/libraries/phocacart');


$lang = JFactory::getLanguage();
$lang->load('com_phocacart');
JHTML::stylesheet('media/com_phocacart/css/main.css' );




//require(JModuleHelper::getLayoutPath('mod_phocacart_product'));
/**
 * content - PhocaCartProduct Plugin
 *
 * @package		Joomla.Plugin
 * @subpakage	PhCProduct.PhocaCartProduct
 */
class plgcontentPhocaCartProduct extends JPlugin {

	/**
	 * Constructor.
	 *
	 * @param 	$subject
	 * @param	array $config
	 */
	 
	function __construct(&$subject, $config = array()) {
		// call parent constructor
		parent::__construct($subject, $config);
	}
	function onContentPrepare($context, &$row, &$params, $limitstart) {


		// Don't run this plugin when the content is being indexed
		if ($context == 'com_content')
		{
			return true;
		}
		$p['display_view_product_button']	= $this->params->get( 'display_view_product_button', 1 );
		$p['display_product_description']	= $this->params->get( 'display_product_description', 0 );				
		$output = $row->text;
		$regex = "#{phocacartproduct}(.*?){/phocacartproduct}#s";
		$found = preg_match_all($regex, $output, $matches);
	
		$count = 0;

		if ($found) {
			foreach ($matches[0] as $value) {
			
			$map = $value;
			$map = str_replace('{phocacartproduct}', '', $map);
			$map = str_replace('{/phocacartproduct}', '', $map);
			$findparam = '|';
			$itparams = explode($findparam, $map);
			$find = ';';
			$product_id = explode($find, $itparams[0]);
			if(isset($itparams[1])) $p['display_view_product_button'] = $itparams[1];
			if(isset($itparams[2])) $p['display_product_description'] = $itparams[2];			
			$html = $this->_render_product($product_id,$p['display_product_description'],$p['display_view_product_button']);
			$row->text = str_replace($value,$html,$row->text);
			}
		}

	return true;


	}
	
	function _render_product(array $product_id, $showdesc, $showdetailbtn) {
			$t['pathitem'] 		= PhocacartPath::getPath('productimage');
			$layoutV	= new JLayoutFile('button_product_view', null, array('component' => 'com_phocacart'));
			$layoutP	= new JLayoutFile('product_price', null, array('component' => 'com_phocacart'));
			$p['display_view_product_button']	= $showdetailbtn;
			$p['display_product_description']	= $showdesc;
			$html = '<div class="ph-product-module-box'.$moduleclass_sfx .'">';
			if(sizeof($product_id)>1) $cols = (100-sizeof($product_id)*5)/sizeof($product_id);
			else $cols = 100;
			if ($p['module_description'] != '') {
				$html .= '<div class="ph-mod-desc">'.$p['module_description'].'</div>';
			}
			if (!empty($product_id)) {
				foreach ($product_id as $k => $pid) {
					
					$v = PhocacartProduct::getProduct($pid,0,0);
					$html .= '<div class="ph-item-box">'; //style="width:auto; display:flex; margin-left:'.sizeof($product_id).'px
					//$html .= $pid;
					$html .= '<div class="thumbnail ph-thumbnail">';
			
					$image = PhocacartImage::getThumbnailName($t['pathitem'], $v->image, 'medium');
//					$link = JRoute::_(PhocacartRoute::getItemRoute($v->id, $v->catid, $v->alias, $v->catalias));
					$link = PhocacartRoute::getItemRoute($v->id, $v->catid, $v->alias, $v->catalias);					
					$html .= '<a href="'.$link.'">';
					if (isset($image->rel) && $image->rel != '') {
						$html .= '<img src="'.JURI::root(true).'/'.$image->rel.'" alt="" class="img-responsive ph-image"';
						$html .= ' />';
					}
					$html .= '</a>';
					
			
					// CAPTION, DESCRIPTION
					$html .= '<div class="caption">';
					$html .= '<a href="'.$link.'">';
					$html .= '<h3>'.$v->title.'</h3>';
					$html .= '</a>';
					// Description box will be displayed even no description is set - to set height and have all columns same height
					$html .= '<div class="ph-item-desc">';
					if ($v->description != '' && (int)$p['display_product_description'] > 0) {
						$html .= $v->description;
					}
					$html .= '</div>';// end desc
					
					// :L: PRICE
					if ($p['hide_price'] != 1) {
						$price 				= new PhocacartPrice;
						$d					= array();
						$d['priceitems']	= $price->getPriceItems($v->price, $v->taxid, $v->taxrate, $v->taxcalculationtype, $v->taxtitle, $v->unit_amount, $v->unit_unit, 1, 1, $v->group_price);
						$d['priceitemsorig']= array();
						if ($v->price_original != '' && $v->price_original > 0) {
							$d['priceitemsorig'] = $price->getPriceItems($v->price_original, $v->taxid, $v->taxrate, $v->taxcalculationtype);
						}
						$d['class']			= 'ph-category-price-box';// we need the same class as category or items view
						$d['product_id']	= (int)$v->id;
						$d['typeview']		= 'Module';
						
						// Display discount price
						// Move standard prices to new variable (product price -> product discount)
						$d['priceitemsdiscount']		= $d['priceitems'];
						$d['discount'] 					= PhocacartDiscountProduct::getProductDiscountPrice($v->id, $d['priceitemsdiscount']);
						
						// Display cart discount (global discount) in product views - under specific conditions only
						// Move product discount prices to new variable (product price -> product discount -> product discount cart)
						$d['priceitemsdiscountcart']	= $d['priceitemsdiscount'];
						$d['discountcart']				= PhocacartDiscountCart::getCartDiscountPriceForProduct($v->id, $v->catid, $d['priceitemsdiscountcart']);
						$html .= $layoutP->render($d);
					}
					
					// VIEW PRODUCT BUTTON
					$html .= '<div class="ph-category-add-to-cart-box">';
					
					// :L: LINK TO PRODUCT VIEW
					if ((int)$p['display_view_product_button'] > 0) {
						$d									= array();
						$d['link']							= $link;
						$d['display_view_product_button'] 	= $p['display_view_product_button'];
						$html .= $layoutV->render($d);
					}
				
					
					$html .= '</div>';// end add to cart box
					$html .= '<div class="clearfix"></div>';
			
					
					$html .= '</div>';// end caption
					
					$html .= '</div>';// end thumbnail
					$html .= '</div>';// end ph-item-box
					unset($v);
				}
			}
			$html .= '</div>';
			
			return $html;
						}
}